%define module_name Crypt-ECDSA-Blind
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/EllipticCurve/Prime.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.015
Release: alt1
Summary: Blind ECDSA Signatures
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HASH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements the blind ECDSA signature protocol outlined in
[1].

    use Crypt::ECDSA::Blind;

    my $ecdsab = new Crypt::ECDSA::Blind;

    my ($pubkey, $seckey) = $ecdsab->keygen;

    my $msg = 'Hello, world!';

    my $init = $ecdsab->init;

    my $req = $ecdsab->request( Key => $pubkey, Init => $init,
                                Message => $msg );

    my $blindsig = $ecdsab->sign( Key => $seckey, Init => $init,
                                  Plaintext => $req );

    my $sig = $ecdsab->unblind( Key => $pubkey, Init => $init,
                                Signature => $blindsig );

    print "Verified\n" if $ecdsab->verify( Key => $pubkey, Message => $msg,
                                           Signature => $sig );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
