%define module_version 0.75
%define module_name Crypt-HCE_SHA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.75
Release: alt1
Summary: Perl extension implementing one way hash chaining encryption using SHA
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EE/EESTABROO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a chaining block cipher using a one way hash.  This method of encryption is the same that is used by radius (RFC2138) and is also described in Applied Cryptography.

Two interfaces are provided in the module.  The first is straight block encryption/decryption the second does base64 mime encoding/decoding of the encrypted/decrypted blocks.

The idea is the the two sides have a shared secret that supplies one of the keys and a randomly generated block of bytes provides the second key.  The random key is passed in cleartext between the two sides.

An example client and server are packaged as modules with this module.  They are used in the tests. They can be found in the examples directory.

Thanks to Jake Angerman for the bug report on the bug in key generation for the chaining portion of the algorithm


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/C*
%perl_vendor_privlib/auto/*

%changelog
