BuildRequires: xvfb-run
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/TuringImage.pm) perl(Business/Bitcoin.pm) perl(Bytes/Random/Secure.pm) perl(Compress/Zlib.pm) perl(Crypt/CBC.pm) perl(Crypt/Diceware.pm) perl(Crypt/ECDSA/Blind.pm) perl(Crypt/EECDH.pm) perl(Crypt/RSA/Blind.pm) perl(Crypt/Random.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(GD/Barcode/QRcode.pm) perl(IO/Socket/INET.pm) perl(IPC/Queue/Duplex.pm) perl(Math/BaseCnv.pm) perl(Math/Prime/Util.pm) perl(Net/Server/PreFork.pm) perl(Persistence/Object/Simple.pm) perl(Test/More.pm) perl(Wx.pm) perl(Wx/Event.pm) perl(Wx/Grid.pm)
# END SourceDeps(oneline)
%define module_name Crypt-HashCash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.130
Release: alt1
Summary: HashCash Digital Cash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HASH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
HashCash is a digital cash system based on blind signatures, as
introduced by David Chaum in [1].

HashCash features a number of optimizations for usability and
accessibility, including blind ECDSA signatures which make for more
compact coins than blind RSA, and a simple protocol that enables the
system to work in a permissionless manner, requiring no user accounts
or registration.

The main components of HashCash are: one or more vaults, which issue
and verify HashCash coins; the coins themselves; and wallets, which
hold and manage coins owned by users.

HashCash coins are blind-signed by a vault and represent specific
denominations of some value stored by the vault. They are bearer
tokens which can be passed directly from one user to another, and
cannot be tracked by the vault.

HashCash coins could be backed by any store of value, some
possibilities being precious metals, fiat currencies, gift cards,
etc. The distribution includes an implementation of a vault for
Bitcoin, which issues HashCash coins backed by Bitcoin.

All messages between wallets and vaults are encrypted, so there's no
need for a secure communications channel between them.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%{expand:%%global __find_requires xvfb-run -a %__find_requires}

%files
%doc README Changes
%perl_vendor_privlib/C*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
