%define module_name Crypt-LE
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Convert/ASN1.pm) perl(Crypt/OpenSSL/Bignum.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(HTTP/Tiny.pm) perl(IO/File.pm) perl(IO/Socket/SSL.pm) perl(JSON/MaybeXS.pm) perl(Log/Log4perl.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Net/SSLeay.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/More.pm) perl(Time/Piece.pm) perl(Time/Seconds.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.39
Release: alt1
Summary: Let's Encrypt API interfacing module and client.
Group: Development/Perl
License: artistic_2
URL: https://do-know.com

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEADER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Crypt::LE provides the functionality necessary to use Let's Encrypt API and generate free SSL certificates for your domains. It can also
be used to generate RSA keys and Certificate Signing Requests or to revoke previously issued certificates. Crypt::LE is shipped with a 
self-sufficient client for obtaining SSL certificates - le.pl.

Provided client supports 'http' and 'dns' domain verification out of the box.

Crypt::LE can be easily extended with custom plugins to handle Let's Encrypt challenges. See the Crypt::LE::Challenge::Simple manpage module
for an example of a challenge-handling plugin.

Basic usage:

le.pl --key account.key --csr domain.csr --csr-key domain.key --crt domain.crt --domains "www.domain.ext,domain.ext" --generate-missing

That will generate an account key and a CSR (plus key) if they are missing. If any of those files exist, they will just be loaded, so it is safe to re-run
the client. Run le.pl without any parameters or with `--help' to see more details and usage examples.

In addition to challenge-handling plugins, the client also supports completion-handling plugins, such as the Crypt::LE::Complete::Simple manpage. You can easily 
handle challenges and trigger specific actions when your certificate gets issued by using those modules as templates, without modifying the client code.
You can also pass custom parameters to your modules from le.pl command line:

le.pl ... --handle-with Crypt::LE::Challenge::Simple --handle-params '{"key1": 1, "key2": "one"}'
 
le.pl ... --complete-with Crypt::LE::Complete::Simple --complete-params '{"key1": 1, "key2": "one"}'
 
The parameters don't have to be put directly in the command line, you could also give a name of a file containing valid JSON to read them from.

le.pl ... --complete-params complete.json
 
Crypt::LE::Challenge:: and Crypt::LE::Complete:: namespaces are suggested for new plugins.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README LICENSE Changes
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
