Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Wordlist.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/Kwalitee.pm) perl(Test/Pod.pm) perl(Test/Spelling.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Crypt-OpenSSL-PKCS10
Version:        0.35
Release:        alt1_3
Summary:        Perl interface to OpenSSL for PKCS10
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Crypt-OpenSSL-PKCS10
Source0:        https://cpan.metacpan.org/modules/by-module/Crypt/Crypt-OpenSSL-PKCS10-%{version}.tar.gz
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
# It's required for successful Crypt::OpenSSL::Guess process.
BuildRequires:  openssl
BuildRequires:  libssl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Crypt/OpenSSL/Guess.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(Crypt/OpenSSL/RSA.pm)
BuildRequires:  perl(File/Slurper.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Import/Into.pm)
BuildRequires:  perl(Test/Lib.pm)
BuildRequires:  perl(Test/More.pm)

# Remove private test modules


Source44: import.info
%filter_from_requires /^perl(Test.Crypt.OpenSSL.PKCS10\|Test.Crypt.OpenSSL.PKCS10.Util.pm)/d
%filter_from_provides /^perl(Test.Crypt.OpenSSL.PKCS10\|Test.Crypt.OpenSSL.PKCS10.Util.pm)/d

%description
Crypt::OpenSSL::PKCS10 Perl module provides the ability to create PKCS10
certificate requests using RSA key pairs.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       openssl
Requires:       perl(Crypt/OpenSSL/RSA.pm)

%description tests
Tests from %{name}-%{version}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Crypt-OpenSSL-PKCS10-%{version}

# Help file to recognize the Perl scripts and normalize shebangs
for F in `find t -name *.t`; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl\b}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}/%{_libexecdir}/%{name}
cp -a t %{buildroot}/%{_libexecdir}/%{name}
# Remove release/author tests
rm %{buildroot}/%{_libexecdir}/%{name}/t/author*
rm %{buildroot}/%{_libexecdir}/%{name}/t/release*
cat > %{buildroot}/%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}/%{_libexecdir}/%{name}/test

%check
unset AUTHOR_TESTING RELEASE_TESTING
make test

%files
%doc Changes README
%{perl_vendor_archlib}/auto/Crypt*
%{perl_vendor_archlib}/Crypt/

%files tests
%{_libexecdir}/%{name}

%changelog
