%define module_name Crypt-Perl
# no openssl; msg genpkey
#define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure/Tiny.pm) perl(Call/Context.pm) perl(Class/Accessor/Fast.pm) perl(Convert/ASN1.pm) perl(Crypt/Format.pm) perl(Crypt/OpenSSL/RSA.pm) perl(CryptX.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(File/Slurp.pm) perl(File/Which.pm) perl(MIME/Base64.pm) perl(Math/BigInt.pm) perl(Math/ProvablePrime.pm) perl(Module/Load.pm) perl(Symbol/Get.pm) perl(Test/Class.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators openssl

Name: perl-%module_name
Version: 0.38
Release: alt1
Summary: Cryptography in pure Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FE/FELIPE/%{module_name}-%{version}.tar.gz
BuildArch: noarch
#Patch33: Crypt-Perl-0.34-syntax.patch

%description
Just as it sounds: cryptography with no non-core XS dependencies!
This is useful if you don.e't have access to
other tools that do this work like OpenSSL, the CryptX manpage,
etc. Of course, if you do have access to one of those tools, they may suit
your purpose better.

See submodules for usage examples of:

=over

=item * Key generation

=item * Key parsing

=item * Signing & verification

=item * Encryption & decryption

=item * Import (the Crypt::Perl::PK manpage) from & export to JSON Web Key format

=item * JWK thumbprints

=item * Certificate Signing Request (PKCS #10) generation (the Crypt::Perl::PKCS10 manpage)

=item * SSL/TLS certificate (X.509) generation (the Crypt::Perl::X509v3 manpage), including
a broad variety of extensions

=back

%prep
%setup -q -n %{module_name}-%{version}
#patch33 -p1

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/C*

%changelog
