%define module_name Crypt-RSA-Blind
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Carp/Assert.pm) perl(Compress/Zlib.pm) perl(Crypt/FDH.pm) perl(Crypt/RSA.pm) perl(Crypt/Random.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Feature/Compat/Class.pm) perl(Math/Pari.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.035
Release: alt1
Summary: Blind RSA signatures
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HASH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Crypt::RSA::Blind;

    my $rsab = new Crypt::RSA::Blind;

    my ($pubkey, $seckey) = $rsab->keygen(Size => 1024);

    my $msg = "Hello, world!";

    my $init = $rsab->init;

    my $req = $rsab->request( Key => $pubkey, Init => $init,
                              Message => $msg );

    my $blindsig = $rsab->sign( Key => $seckey, Plaintext => $req );

    my $sig = $rsab->unblind( Key => $pubkey, Init => $init,
                              Signature => $blindsig );

    print "OK\n" if $rsab->verify( Key => $pubkey, Message => $msg,
                                   Signature => $sig );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/C*

%changelog
