%define module_version 1.01
%define module_name Crypt-Serpent
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt8
Summary: Crypt::CBC compliant Serpent block cipher encryption module
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JH/JHUGHES/%{module_name}-%{module_version}.tar.gz
# TODO: fix compilation on other arches
ExclusiveArch: %{ix86}

%description
From the Tropical Software Serpent page...

"Serpent was designed by Ross Anderson, Eli Biham and Lars Knudsen as a
candidate for the Advanced Encryption Standard. It has been selected as
one of the five finalists in the AES competition. Serpent is faster than
DES and more secure than Triple DES. It provides users with a very high
level of assurance that no shortcut attack will be found. To achieve this,
the algorithm's designers limited themselves to well understood cryptography
mechanisms, so that they could rely on the wide experience and proven
techniques of block cipher cryptanalysis. The algorithm uses twice as many
rounds as are necessary to block all currently known shortcut attacks. This
means that Serpent should be safe against as yet unknown attacks that may be
capable of breaking the standard 16 rounds used in many types of encryption
today. However, the fact that Serpent uses so many rounds means that it is
the slowest of the five AES finalists. But this shouldn't be an issue because
it still outperforms Triple DES. The algorithm's designers maintain that
Serpent has a service life of at least a century."

"Serpent is a 128-bit block cipher, meaning that data is encrypted and
decrypted in 128-bit chunks. The key length can vary, but for the purposes
of the AES it is defined to be either 128, 192, or 256 bits. This block size
and variable key length is standard among all AES candidates and was one of
the major design requirements specified by NIST. The Serpent algorithm uses
32 rounds, or iterations of the main algorithm."

=over 4


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYING CHANGES
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
