%define module_name Crypt-URandom-MonkeyPatch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/URandom.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Module/Metadata.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(constant.pm) perl(strict.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1
Summary: override core rand function to use system random sources
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRWO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module globlly overrides the builtin Perl function `rand' with one based on the operating system's cryptographic
random number source, e.g. /dev/urandom.

The purpose of this module is monkey patch legacy code that uses `rand' for security purposes.

You can verify that it is working by running code with the `CRYPT_URANDOM_MONKEYPATCH_DEBUG' environment variable set,
e.g.

    local $ENV{CRYPT_URANDOM_MONKEYPATCH_DEBUG} = 1;

    my $salt = random_string("........");

Every time the `rand' function is called, it will output a line such as

    Crypt::URandom::MonkeyPatch::urandom used from Some::Package line 123

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc SECURITY.md CONTRIBUTING.md LICENSE Changes README.md
%perl_vendor_privlib/C*

%changelog
