%define module_name Crypt-X509-CRL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Convert/ASN1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4
Release: alt1
Summary: Parses an X.509 certificate revocation list
Group: Development/Perl
License: artistic_2
URL: https://github.com/gigageeks/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GI/GIGAGEEK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Crypt::X509::CRL parses X.509 certificate revocation lists. Methods are
provided for accessing most CRL elements.

It is based on the generic ASN.1 module by Graham Barr, on the
x509decode example by Norbert Klasen and contributions on the
perl-ldap-dev-Mailinglist by Chriss Ridd. It is also based upon the
works of Mike Jackson and Alexander Jung perl module Crypt::X509.

The following RFC 3280 Extensions are available (noted are the ones I
have implemented).

_Authority Key Identifier (implemented)
_CRL Number (implemented)
_Issuing Distribution Point (implemented)
_Issuer Alternative Name
_Delta CRL Indicator
_Freshest CRL (a.k.a. Delta CRL Distribution Point)

The following RFC 3280 CRL Entry Extensions are available (noted are the
ones I have implemented).

_Reason Code (implemented)
_Hold Instruction Code (implemented)
_Invalidity Date (implemented)
_Certificate Issuer

NOTE: The use of 'utcTime' in determining the revocation date of a given
certificate is based on RFC 3280 for dates through the year 2049.  Starting
with dates in 2050 and beyond the RFC calls for revocation dates to be
listed as 'generalTime'.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_privlib/C*

%changelog
