%define module_name CryptoCurrency-Catalog
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20181129.0.0
Release: alt1
Summary: Catalog of cryptocurrencies
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/CryptoCurrency-Catalog

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class attempts to provide a list/catalog of cryptocurrencies. The main
source for this catalog is the Cryptocurrency Market Capitalizations website
(https://coinmarketcap.com/, or CMC for short).

CMC does not provide unique symbols nor unique names, only unique "safenames"
(slugs). Whenever there is a clash, this catalog modifies the clashing symbol
and/or unique name to make symbol and name to be unique again (usually the
coin/token with the smaller market cap "loses" the name).

There is no guarantee that the symbol/name/safename of old/unlisted coins or
tokens will not be reused.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
