%define module_name Curio
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(Import/Into.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Package/Stash.pm) perl(Scalar/Util.pm) perl(Sub/Name.pm) perl(Test2/V0.pm) perl(Type/Utils.pm) perl(Types/Common/String.pm) perl(Types/Standard.pm) perl(namespace/clean.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Procurer of fine resources and services.
Group: Development/Perl
License: gpl
URL: https://github.com/bluefeet/Curio

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUEFEET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Curio is a library for creating the Moo manpage classes which encapsulate the
construction and retrieval of arbitrary resources.  As a user of this
library you've got two jobs.

First, you create classes in your application which use Curio.  You'll
have one class for each type of resource you want available to your
application as a whole.  So, for example, you'd have a Curio class for
your database connections, another for your graphite client, and perhaps
a third for your CRM client.

Your second job is to then modify your application to use your Curio
classes.  If your application uses an existing framework, such as
the Catalyst manpage or the Dancer2 manpage, then you may want to take a look at the
available the INTEGRATIONS entry elsewhere in this document.

Keep in mind that Curio doesn't just have to be used for connections
to remote services.  It can be used to make singleton classes, as a
ready to go generic object factory, a place to put global application
context information, etc.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/C*

%changelog
