Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_DBD_Mock_enabled_optional_test

Name:           perl-DBD-Mock
Version:        1.59
Release:        alt1_3
Summary:        Mock database driver for testing
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/DBD-Mock
Source0:        https://cpan.metacpan.org/modules/by-module/DBD/DBD-Mock-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Module/Build/Tiny.pm)
BuildRequires:  perl(strict.pm)
# Run-time
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_DBD_Mock_enabled_optional_test}
# Optional tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:       perl(DBI.pm) >= 1.300
Requires:       perl(List/Util.pm) >= 1.270

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(DBI\|List.Util\|Test.Exception\|Test.More\).pm)/d

%description
Testing with databases can be tricky. If you are developing a system married
to a single database then you can make some assumptions about your environment
and ask the user to provide relevant connection information.  But if you need
to test a framework that uses DBI, particularly a framework that uses
different types of persistence schemes, then it may be more useful to simply
verify what the framework is trying to do -- ensure the right SQL is generated
and that the correct parameters are bound. DBD::Mock makes it easy to just
modify your configuration (presumably held outside your code) and just use it
instead of DBD::Foo (like DBD::Pg or DBD::mysql) in your framework.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(DBI.pm) >= 1.300
Requires:       perl(Test/Exception.pm) >= 0.310
Requires:       perl(Test/More.pm) >= 0.470
%if %{with perl_DBD_Mock_enabled_optional_test}
Requires:       perl(Test/Pod/Coverage.pm) >= 1.040
%endif

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n DBD-Mock-%{version}
%if !%{with perl_DBD_Mock_enabled_optional_test}
rm 998_pod.t 999_pod_coverage.t
%endif
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Build.PL --installdirs=vendor
./Build

%install
#find blib/libdoc -type f -empty -delete
./Build install --destdir=%{buildroot} --create_packlist=0
# Install tests
mkdir -p %{buildroot}/%{_libexecdir}/%{name}
cp -a t %{buildroot}/%{_libexecdir}/%{name}
%if %{with perl_DBD_Mock_enabled_optional_test}
rm %{buildroot}/%{_libexecdir}/%{name}/t/998_pod.t
%endif
cat > %{buildroot}/%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
set -e
unset REPORT_TEST_ENVIRONMENT
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}/%{_libexecdir}/%{name}/test
# Correct permissions
# %{_fixperms} %{buildroot}/*

%check
unset REPORT_TEST_ENVIRONMENT
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes CONTRIBUTING.md README.md
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
