%define module_name DBD-mysqlPPrawSjis
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Tar.pm) perl(Compress/Zlib.pm) perl(Config.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(FindBin.pm) perl(Getopt/Std.pm) perl(Net/MySQL.pm) perl(Test.pm) perl(Test/Harness.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Pure Perl MySQL driver for raw ShiftJIS
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INA/DBD/mysqlPPrawSjis/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
DBD::mysqlPPrawSjis is a Pure Perl client interface for the MySQL database.
This module implements network protool between server and client of MySQL,
thus you don't need external MySQL client library like libmysqlclient for
this module to work. It means this module enables you to connect to MySQL
server from some operation systems which MySQL is not ported.
Using this software and Sjis software, you can store ShiftJIS literal into
MySQL database without code conversion at all. How nifty!

From perl you activate the interface with the statement

    use DBI;

After that you can connect to multiple MySQL database servers
and send multiple queries to any of them via a simple object oriented
interface. Two types of objects are available: database handles and
statement handles. Perl returns a database handle to the connect
method like so:

  $dbh = DBI->connect("dbi:mysqlPPrawSjis:database=$db;host=$host",
              $user, $password, {RaiseError => 1});

Once you have connected to a database, you can can execute SQL
statements with:

  my $query = sprintf("INSERT INTO foo VALUES (%%d, %%s)",
              $number, $dbh->quote("name"));
  $dbh->do($query);

See the DBI(3) manpage for details on the quote and do methods. An alternative
approach is

  $dbh->do("INSERT INTO foo VALUES (?, ?)", undef,
       $number, $name);

in which case the quote method is executed automatically. See also
the bind_param method in the DBI(3) manpage. See the DATABASE HANDLES entry elsewhere in this document below
for more details on database handles.

If you want to retrieve results, you need to create a so-called
statement handle with:

  $sth = $dbh->prepare("SELECT id, name FROM $table");
  $sth->execute();

This statement handle can be used for multiple things. First of all
you can retreive a row of data:

  my $row = $sth->fetchow_arrayref();

If your table has columns ID and NAME, then $row will be array ref with
index 0 and 1. See the STATEMENT HANDLES entry elsewhere in this document below for more details on
statement handles.

I's more formal approach:
%prep
%setup -q -n %{module_name}-%{version}
#mkdir lib; cp -a DBD lib/

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
