Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: perl(DBD/DBM.pm)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-DBI-Dumper
Version:        2.01
Release:        alt13_61
Summary:        Dump data from a DBI datasource to file
# see http://rt.cpan.org/Public/Bug/Display.html?id=27269
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/DBI-Dumper
Source0:        https://cpan.metacpan.org/authors/id/W/WS/WSMITH/DBI-Dumper-%{version}.tar.gz
# Perl 5.18 compatibility, CPAN RT#87243
Patch0:         DBI-Dumper-2.01-qw-does-not-produce-parentheses.patch

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Inline.pm)
# Run-time
BuildRequires:  perl(DBI.pm) 
BuildRequires:  perl(Inline/C.pm)
BuildRequires:  perl(Parse/RecDescent.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Term/ReadKey.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Test/More.pm)



Source44: import.info
%filter_from_provides /perl(Parse.RecDescent.DBI.Dumper.Grammar.pm)/d

%description
Dumps data from a select statement into an output file. dbidumper tries
to mirror the functionality and behavior of sql*loader. The control
file syntax is similar, and DBI::Dumper utilizes a subset of the
sql*loader options.

%prep
%setup -q -n DBI-Dumper-%{version}
%patch0  -p1

# include some licensing information from the rt.cpan.org bug, as it's
# not yet included in the package proper
cat << \EOF > COPYING.fedora
DBI::Dumper is under the same terms as perl itself, namely the GPL or 
Artistic licenses.  For more information, please see:

  http://rt.cpan.org/Public/Bug/Display.html?id=27269

From the bug:

Subject: RE: [rt.cpan.org #27269] DBI::Dumper license?
Date:    Thu, 24 May 2007 10:58:37 -0500
To:      <bug-DBI-Dumper[...]rt.cpan.org>
From:   "Smith Warren - wasmit" <Warren.Smith[...]acxiom.com>

The license for DBI::Dumper is the same as perl. I will update the
POD with the next release to include this information.

EOF

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}


%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -a -size 0 -delete
# %{_fixperms} %{buildroot}/*

# EU::MM seems to be horribly confused
rm -rf %{buildroot}${PWD}

%check
make test

%files
%doc --no-dereference COPYING.fedora
%doc Changes grammar.prd README t/
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/DBI
%{_bindir}/*
%{_mandir}/man[13]/*

%changelog
