%define module_name DBIx-Class-BcryptColumn
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/Bcrypt.pm) perl(Crypt/URandom.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MakeMaker.pm) perl(Sub/Name.pm) perl(Test/DBIx/Class.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001003
Release: alt1
Summary: Set a column to securely hash on insert/update using bcrypt
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/DBIx-Class-BcryptColumn

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
It's considered best practice to store credential data about your system users (such as passwords)
using a one way hashing algorithm.  That way if your system gets hack and your database becomes
compromised then at least the hackers won't know everyone's password.  It also is useful as a
protective measure against in-house bad actors who have access to your production system as part
of their regular job duties.

There's a few distributions on CPAN to make it easier to do this with the DBIx::Class manpage.  The two most
commonly cited are the DBIx::Class::PassphraseColumn manpage and the DBIx::Class::EncodedColumn manpage.  Those are
both good choices for this problem and all things equal you might want to review those before making
a final choice.  The main reason I wrote this was to solve two issues for me.  First, both of those
perform hashing on `new' or `set_column' instead of on insert / update as this module does.  That
approach is considered more secure by the DBIC community since it means that there is never a time
where unhashed passwords are in DBIC code and if you have a core dump or similar error those plain
text passwords have no chance of ending up in a file readable by an unauthorized person.  However if
you are using the Valiant manpage and its DBIC glue the DBIx::Class::Valiant manpage this means you can't apply any
validation rules at the DBIC level such as minimal password complexity, or do things like use the
confirmation validator, since hashing on `new' / `set_column' would happen before validation occurs
(In the DBIx::Class::Valiant manpage validation doesn't happen until you try to update / insert the data, or if
you manually invoke `validate').  So For the Valiant manpage users I wrote this as an option to allow you
to do those things if you are willing to accept the additional risk of plain text passwords in live
memory.  Personal I find this to be a minimal additional risk since it's likely those password will reside
in other parts of the code memory space anyway (such as in the...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE README.mkdn
%perl_vendor_privlib/D*

%changelog
