# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name DBIx-Class-Bootstrap-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Simplistic bootstrapping for DBIx::Class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MJ/MJFLICK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Your model:

   package YourNamespace::DB::User;

   use base 'DBIx::Class::Bootstrap::Simple';

   use strict;
   
   __PACKAGE__->init(
       table       => 'users',
       primary_key => 'user_id',
       definition  => [
           {
              key     => 'user_id',
              type    => 'INT(11)',
              special => 'AUTO_INCREMENT',
              null    => 0,
              primary => 1,
           },
           {
               key   => 'company_id',
               type  => 'INT',
           },
           {
              key     => 'password_id',
              type    => 'INT(11)',
           },
           {
              key     => 'stash',
              type    => 'BLOB',
           },
       },
       # link datetime objects here as well
       objects => {
           # class must have an inflate and deflate method
           # inflate method is Class->inflate(value_to_inflate)
           # deflate is $yourinflated_object->deflate;
           stash => 'YourApp::DB::DataType::Stash',
       },
       references  => {
           company => {
               class          => 'YourApp::DB::Company',
               column         => 'company_id',
               cascade_update => 1, #defaults to 0
               cascade_delete => 1, #defaults to 0
               cascade_copy   => 1, #defaults to 0

           },
           password => {
               class  => 'YourApp::DB::Password',
               column => 'password_id',
           },
       }
   );

Your application:

   # load other model classes
   DBIx::Class::Bootstrap::Simple->build_relations;
   my $schema = DBIx::Class::Bootstrap::Simple->connect(sub { });

   # on a connection basis
   $schema->storage->DESTROY;
   my $dbh = DBI->connect(..., {  RaiseError => 1 });
   $schema->storage->connect_info([{
       dbh_maker => sub { $dbh }
   }]);
   
   sub db
   {
       my ($self, $table) = @_;
   
       die "invalid table name: $table"
           unless $DBIx::Class::Bootstrap::Simple::CONFIG{$table};

       return $schema->model($table);
   }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING AUTHORS README
%perl_vendor_privlib/D*

%changelog
