Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run optional tests
%{bcond_without perl_DBIx_Class_DateTime_Epoch_enables_optional_test}

Name:           perl-DBIx-Class-DateTime-Epoch
Summary:        Automatic inflation/deflation of epoch-based DateTime objects for DBIx::Class
Version:        0.10
Release:        alt2_37
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/DBIx-Class-DateTime-Epoch
Source0:        https://cpan.metacpan.org/authors/id/B/BR/BRICAS/DBIx-Class-DateTime-Epoch-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DBIx/Class.pm)
# DBIx::Class::InflateColumn::DateTime loaded via __PACKAGE__->load_components()
BuildRequires:  perl(DBIx/Class/InflateColumn/DateTime.pm)
# DBIx::Class::TimeStamp loaded via __PACKAGE__->load_components()
BuildRequires:  perl(DBIx/Class/TimeStamp.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
# DateTime::Format::SQLite is loaded by DBICx::TestDatabase when SQLite database
BuildRequires:  perl(DateTime/Format/SQLite.pm)
BuildRequires:  perl(DBICx/TestDatabase.pm)
# DBIx::Class::Core loaded via __PACKAGE__->load_components()
BuildRequires:  perl(DBIx/Class/Core.pm)
BuildRequires:  perl(DBIx/Class/Schema.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_DBIx_Class_DateTime_Epoch_enables_optional_test}
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:       perl(DBIx/Class.pm) >= 0.081.030
# DBIx::Class::InflateColumn::DateTime loaded via __PACKAGE__->load_components()
Requires:       perl(DBIx/Class/InflateColumn/DateTime.pm)
# DBIx::Class::TimeStamp loaded via __PACKAGE__->load_components()
Requires:       perl(DBIx/Class/TimeStamp.pm) >= 0.070


# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(DBIx.Class.pm)/d

%description
This module automatically inflates/deflates DateTime objects
corresponding to applicable columns. Columns may also be defined to
specify their nature, such as columns representing a creation time
(set at time of insertion) or a modification time (set at time of
every update).


%prep
%setup -q -n DBIx-Class-DateTime-Epoch-%{version}
# Remove bundled libraries
rm -r inc
sed -i -e '/^inc\// d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
