# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Storable.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 1
%define module_name DBIx-Class-FrozenColumns
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1
Release: alt1
Summary: Store virtual columns inside another column.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SY/SYBER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to store multiple columns in one. This is useful when
you want to store dynamic number of columns in database or you just don't know
what columns will be stored there. Or when you can't (or don't want) to alter
your tables in database.

Module allows you to transparently use this columns as if they were normal
columns in your table. With one obvious restriction: you cannot search rows in a
table and therefore you cannot add relationships using these columns (search is
needed to build reverse relationship).

Module handles its own dirty column management and will not update the parent
field unless any columns is changed.

Note: The component needs to be loaded before Core and plugin 'Ordered'.
If you get an error like 'no such column: <frozencolumn>' while updating a row
then try to move this module more closer to the start of the load_components
list.

Also note that frozen column IS NOT a real column of your result class.
This impose some restrictions on use of this columns such as searching, adding
relationships, has_column, get_columns, etc.
See the EXTENDED METHODS entry elsewhere in this document for the list of method that will work with frozen
columns (as will methods that use it).

Module unpacks frozen columns only once when you first accessing it and packs
when you call update.

You can also create frozen columns in another frozen column any level deep.
The only restriction is that they all use the same storing mechanism.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/D*

%changelog
