%define module_name DBIx-Class-Helper-TableSample
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/ResultSet.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Module/Metadata.pm) perl(Pod/Coverage/TrustPod.pm) perl(Ref/Util.pm) perl(SQL/Abstract.pm) perl(SQL/Abstract/Test.pm) perl(SQL/Translator.pm) perl(Test/CleanNamespaces.pm) perl(Test/EOL.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Roo.pm) perl(Test/Roo/Role.pm) perl(base.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.7.0
Release: alt1
Summary: Add support for tablesample clauses
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRWO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This helper adds rudimentary support for tablesample queries
to the DBIx::Class manpage resultsets.

The `tablesample' key supports the following options as a hash
reference:

=over

=item `fraction'

This is the percentage or fraction of the table to sample,
between 0 and 100, or a numeric expression that returns
such a value.

(Some databases may restrict this to an integer.)

The value is not checked by this helper, so you can use
database-specific extensions, e.g. `1000 ROWS' or `15 PERCENT'.

Scalar references are dereferenced, and expressions or
database-specific extensions should be specified has scalar
references, e.g.

  my $rs = $schema->resultset('Wobbles')->search_rs(
    undef,
    {
      columns     => [qw/ id name /],
      tablesample => {
        fraction => \ "1000 ROWS",
      },
    }
  );

=item `type'

By default, there is no sampling type., e.g. you can simply use:

  my $rs = $schema->resultset('Wobbles')->search_rs(
    undef,
    {
      columns     => [qw/ id name /],
      tablesample => 5,
    }
  );

as an equivalent of

  my $rs = $schema->resultset('Wobbles')->search_rs(
    undef,
    {
      columns     => [qw/ id name /],
      tablesample => { fraction => 5 },
    }
  );

to generate

  SELECT me.id FROM artist me TABLESAMPLE (5)

If your database supports or requires a type, you can specify it,
e.g. `system' or `bernoulli'.

See your database documentation for the allowable types.

=item `repeatable'

If this key is specified, then it will add a REPEATABLE clause,
e.g.

  my $rs = $schema->resultset('Wobbles')->search_rs(
    undef,
    {
      columns     => [qw/ id name /],
      tablesample => {
        fraction   => 5,
        repeatable => 123456,
      },
    }
  );

to generate

  SELECT me.id FROM artist me TABLESAMPLE (5) REPEATABLE (123456)

Scalar references are dereferenced, and expressions or
database-specific extensions should be specified has scalar
references.

=back

Resultsets with joins or inner queries are not supported.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/D*

%changelog
