%define module_version 0.003000
%define module_name DBIx-Class-InflateColumn-Boolean
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MakeMaker.pm) perl(Path/Class.pm) perl(SQL/Translator.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003000
Release: alt1
Summary: Auto-create boolean objects from columns.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRAF/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Perl does not have a native boolean data type by itself, it takes
certain several scalar values as `false' (like '', 0, 0.0) as well as
empty lists and `undef', and everything else is `true'. It is also
possible to set the boolean value of an object instance.

As in most program code you have boolean data in nearly every database.
But for a database it is up to the designer to decide what is `true'
and what is `false'.

This module maps such "database booleans" into "Perl booleans" and back
by inflating designated columns into some sort of boolean objects, that
happen to be instances of Contextual::Return::Value.
Objects of this class can store the original value and a boolean meaning
at the same time. Therefore - if `Yes' in the database means `true'
and `No' means `false' in the application the following two lines can
virtually mean the same:

  if ($table->field eq "No") { ... }
  if (not $table->field) { ... }

That means that `$table->field' has the scalar value `"No"', but
is taken as `false' in a boolean context, whereas without the little
magic from Contextual::Return Perl would regard
the string `"No"' as `true'.

When writing to the database, of course `$table->field' would be
deflated to the original value `"No"' and not some Perlish form of a
boolean.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/D*

%changelog
