# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(NetAddr/IP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Html.pm) perl(Pod/Man.pm) perl(Pod/Text.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02003
%define module_name DBIx-Class-InflateColumn-IP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02003
Release: alt1
Summary: Auto-create NetAddr::IP objects from columns.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IL/ILMARI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Load this component and declare columns as IP addresses with the
appropriate format.

    package Host;
    __PACKAGE__->load_components(qw/InflateColumn::IP Core/);
    __PACKAGE__->add_columns(
        ip_address => {
            data_type => 'bigint',
            is_nullable => 0,
            is_ip => 1,
            ip_format => 'numeric',
        }
    );

    package Network;
    __PACKAGE__->load_components(qw/InflateColumn::IP Core/);
    __PACKAGE__->add_columns(
        address => {
            data_type => 'varchar',
            size        => 18
            is_nullable => 0,
            is_ip => 1,
            ip_format => 'cidr',
        }
    );

Then you can treat the specified column as a NetAddr::IP object.

    print 'IP address: ', $host->ip_address->addr;
    print 'Address type: ', $host->ip_address->iptype;

DBIx::Class::InflateColumn::IP supports a limited amount of
auto-detection of the format based on the column type. If the type
begins with `int' or `bigint', it's assumed to be numeric, while
`inet' and `cidr' (as used by e.g. PostgreSQL) are assumed to be
`cidr' format.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
