# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/C3/Componentised.pm) perl(DBD/Pg.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/QueryLog.pm) perl(DBIx/Class/QueryLog/Analyzer.pm) perl(DBIx/Class/ResultSet.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Class/Schema/Loader.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Moose.pm) perl(MooseX/MarkAsMethods.pm) perl(MooseX/NonMoose.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(Try/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name DBIx-Class-PgLog
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Postgres simple activity loging for DBIx::Class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHEEJU/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Enable the PgLog schema component in your the DBIx::Class::Schema manpage class file:

    package My::Schema;
    use base qw/DBIx::Class::Schema/;

    __PACKAGE__->load_components(qw/Schema::PgLog/);

Enable the PgLog component in your the individual the DBIx::Class manpage table class files that you want to enable logging on:

    package My::Schema::Result::Table
    use base qw/DBIx::Class::Core/;

    __PACKAGE__->load_components(qw/PgLog/);

If you want to use methods created by the DBIx::Class::Relationship::Base manpage, like "add_to_$rel" or "set_$rel",
if you are planing to use the delete entry in the DBIx::Class::ResultSet manpage or the update entry in the DBIx::Class::ResultSet manpage or if you use
modules which make use of these methods (like the HTML::FormHandler manpage or the DBIx::Class::ResultSet::RecursiveUpdate manpage,
load the PgLog-component in your ResultSet classes:

    package My::Schema::ResultSet::Table;

    use base 'DBIx::Class::ResultSet';

    __PACKAGE__->load_components('ResultSet::PgLog');

    1;

In your application wrap any insert/update/delete in a transaction to have pg log activated:

* Mandatorily Pass an extra hashref to the txn_do method to indicate a UserId and optional Description for the transaction:

    $my_schema->txn_do(
        sub {
            $my_row->update({ ... });
        },
        {
            UserId => 'User_id',
            Description => 'description of transaction' # optional
        }
    );
%prep
%setup -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.pod
%perl_vendor_privlib/D*

%changelog
