%define module_version 0.03
%define module_name DBIx-Class-Report
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema/Loader.pm) perl(Digest/MD5.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Install.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(namespace/autoclean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Ad-Hoc reporting from DBIx::Class
Group: Development/Perl
License: artistic2
URL: https://github.com/Ovid/dbix-class-report

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
NOTE: Experimental ALPHA code.

Sometimes it's nice to be able to run ad-hoc SQL and get back a the DBIx::Class manpage
resultset. We can use the DBIx::Class::ResultSource::View manpage, but that requires we
hard-code our SQL ahead of time. `DBIx::Class::Report' allows you to create
your SQL on the fly and generate ad-hoc, read-only dbic resultsets which act
just like normal dbic objects.

    my $sql = <<'SQL';
      SELECT var.name, ce.event_type, count(*)
        FROM tracking_conversion_event ce
        JOIN tracking_visitor visitor      ON visitor.tracking_visitor_id      = ce.tracking_visitor_id
        JOIN tracking_version_variant curr ON curr.tracking_version_variant_id = visitor.tracking_version_variant_id
        JOIN tracking_version ver          ON ver.tracking_version_id          = curr.tracking_version_id
        JOIN tracking_variant var          ON var.tracking_variant_id          = curr.tracking_variant_id
       WHERE ver.tracking_id = ?
         AND ver.version     = ?
    GROUP BY 1, 2
    SQL

    my $events_per_name = DBIx::Class::Report->new(
       schema  => $schema,
       sql     => $sql,
       columns => [qw/name event_type total/],
    );

    my $resultset = $events_per_name->fetch( $tracking_id, $version );
    say $resultset->count; # yeah, it behaves just like a normal dbic resultset

    while ( my $result = $resultset->next ) {
       say $result->name;
       say $result->event_type;
       say $result->total;
    }


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
