# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBIx/Class/Candy.pm) perl(DBIx/Class/Candy/Exports.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Relationship/Base.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Lingua/EN/Inflexion.pm) perl(Modern/Perl.pm) perl(Sub/Quote.pm) perl(Test/DBIx/Class.pm) perl(Test/More.pm) perl(Test2/Plugin/ExitSummary.pm) perl(Test2/Plugin/NoWarnings.pm) perl(Test2/Plugin/Times.pm) perl(Test2/V0.pm) perl(base.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name DBIx-Class-TemporalRelations
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9000
Release: alt1
Summary: Establish and introspect time-based relationships between tables.
Group: Development/Perl
License: perl
URL: https://p3rl.org/DBIx::Class::TemporalRelations

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GEEKRUTH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module sets up some convenience methods describing temporal relationships between
data elements. A fairly-common construct would be to have a table of users, who are
creating things, and we want to see lists of the things that they created, in a time
order. In SQL, this might be:

   SELECT id, serial_number, created_dt 
   FROM thing 
   WHERE creator = (SELECT id FROM user WHERE username = 'geekruthie')
   ORDER BY created_dt;

And in conventional the DBIx::Class manpage parlance:

   $schema->resultset('User')->find({ username => 'geekruthie'} )->things
      ->search({},{ order_by => 'created_dt'});

Easy enough, but with this module, you can do some more things that would require a bit more yak-shaving:

   my $user = $schema->resultset('User')->find({username => 'geekruthie'});
   @things = $user->things_created;
   @things = $user->things_created_before($ts);
   @things = $user->things_created_after($ts);

These methods let you order things in reverse-date order:

   @things = $user->most_recent_things_created;
   @things = $user->most_recent_things_created_before($ts);
   @things = $user->most_recent_things_created_after($ts);

...and let's pick a specific thing, shall we?

   $thing = $user->first_thing_created;
   $thing = $user->last_thing_created;
   $thing = $user->first_thing_created_after($ts);
   $thing = $user->last_thing_created_before($ts);

And if you could also modify things, and stashed the last time the thing was modified, and by whom, in the
`thing' table:

   @thing = $user->things_modified;
   $thing = $user->last_thing_modified;

(...but see the BUGS AND LIMITATIONS entry elsewhere in this document for an important limitation on this behavior!)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CODE_OF_CONDUCT.md README.mkdn AUTHOR_PLEDGE Changes LICENSE
%perl_vendor_privlib/D*

%changelog
