# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBIx/Connect/MySQL.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name DBIx-Conn-MySQL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Shortcut to connect to MySQL database
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/DBIx-Conn-MySQL

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module offers some saving in typing when connecting to a MySQL database
using the DBI manpage, and is particularly handy in one-liners. First, it uses
the DBIx::Connect::MySQL manpage to connect so you don't have to supply username and
password if you have configuration file (e.g. ~/.my.cnf); that module will
search the username and password from configuration files.

Second, it automatically `connect()' and exports the database handle `$dbh'
for you.

You often only have to specify the database name in the import argument:

 -MDBIx::Conn::MySQL=mydb

This will result in the following DSN:

 DBI:mysql:database=mydb

If you need to specify other parameters in the DSN, e.g. when the `host' is not
`localhost', or the `port' is not the default port, you can specify that in
the first import argument too (note the quoting because the shell will interpret
`;' as command separator). When the first import argument contains `=', the
module knows that you want to specify DSN parameters:

 -MDBIx::Conn::MySQL='mydb;host=192.168.1.10;port=23306'

this will result in the following DSN:

 'DBI:mysql:database=mydb;host=192.168.1.10;port=23306

If you want to use another variable name other than the default `$dbh' for the
database handle, you can specify this in the second import argument (note the
quoting because otherwise the shell will substitute with shell variable):

 -MDBIx::Conn::MySQL=mydb,'$handle'

Lastly, if you want to supply username and password anyway, you can do that via
the third and fourth import arguments (or the second and third import arguments,
as long as the username does not begin with `$'):

 -MDBIx::Conn::MySQL=mydb,'$handle',myuser,mysecret
 -MDBIx::Conn::MySQL=mydb,myuser,mysecret

But note that specifying passwords on the command-line is not recommended (hence
the use of DBIx::Connect::MySQL in the first place).

=for Pod::Coverage ^(.+)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/D*

%changelog
