%define module_name DBIx-ScopedTransaction
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Data/Validate/Type.pm) perl(File/Spec.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2.0
Release: alt1
Summary: Scope database transactions on DBI handles in code, to detect and prevent issues with unterminated ...
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/DBIx-ScopedTransaction

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Small class designed to be instantiated in a localized scope. Its purpose
is to start and then clean up a transaction on a DBI object, while detecting
cases where the transaction isn't terminated properly.

The synopsis has an example of working code, let's see here an example in
which DBIx::ScopedTransaction helps us to detect a logic error in how the
programmer handled terminating the transaction.

_sub test
_{
__my $transaction = DBIx::ScopedTransaction->new( $dbh );
__try
__{
___# Do some work on $dbh that may succeed or fail.
__}
__catch
__{
___$transaction->rollback();
__};
_}

_test();

As soon as the test() function has been run, $transaction goes out of scope and
gets destroyed by Perl. DBIx::ScopedTransaction subclasses destroy and detects
that the underlying transaction has neither been committed nor rolled back,
and forces a rollback for safety as well as prints details on what code should
be reviewed on STDERR.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md ignore.txt examples
%perl_vendor_privlib/D*

%changelog
