%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): /usr/bin/perldoc perl(Config.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Storable.pm) perl(Thread/Queue/Duplex.pm) perl(Thread/Queue/Queueable.pm) perl(Time/HiRes.pm) perl(base.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name DBIx-Threaded
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Proxy class to permit DBI objects to be
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DARNOLD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
DBIx::Threaded provides a subclass of the DBI manpage that provides wrappers for
standard DBI objects to permit them to be used by multiple threads.
Due to the limitations of threading and tied objects in Perl 5, DBI
(as of version 1.48), does not permit DBI-generated objects
(namely, connection and statement handles) to be used outside
of the thread in which they are created.

Due to its architecture, DBIx::Threaded also has the pleasant 
side-effect of providing thread-safe access to DBD's which are not 
otherwise thread-friendly or thread-safe (assuming any underlying
client libraries and/or XS code are thread-safe, e.g., do not
rely on unrestricted access to process-global variables).

DBIx::Threaded accomplishes this by spawning a separate server
(or *apartment*) thread to encapsulate a DBI container class 
the DBIx::Threaded::Server manpage, for each connection 
created by the connect() method. All the DBI connection and statement 
interfaces for a single connection are then executed within that thread
(note that this is, in some respects, similar to the way Perl manages
threads::shared variables).

Separate client DBI connection and statement subclasses are also defined
to provide stub method implementations for the various DBI API
interfaces, DBI attributes, and any DBD-specific installed methods or 
attributes.

A the Thread::Queue::Duplex manpage *aka TQD)* object is created for each connection
to provide a lightweight communication channel between the client stubs and
the server container objects, passing parameters and results between
the client and server using either the threads::shared manpage variables
for simple scalars and structures, or marshalling via the Storable manpage for more
complex structures.

Note that, due to the way in which Perl threads are spawned
(i.e., cloning the entire interpretter context of the spawning thread),
a `dbix_threaded_create_pool()' class level method is provided to permit creation
of minimal context threads during application initialization, in order
to conserve memory resources.

Also note that DBIx::Threaded supports DBI subclass chaining so that,
e.g., it is possible to use the DBIx::Chart manpage with DBIx::Threaded. The subclass
may be specified either as an imported hash value in the form

_use DBIx::Threaded subclass => SubClass;

or in the `connect()' call via the `RootClass' attribute, as
supported by the DBI manpage.

Finally, in the event DBIx::Threaded is used in a Perl environment
that does not support threads (i.e., `$Config{useithreads}' is false),
it will fallback to the basic DBI behaviors, i.e., `connect()' will
simply call `DBI->connect()', and thus the caller will get a regular
DBI connection handle (or, if subclasses were declared when 
DBIx::Threaded was `use''d, a subclassed connection handle).

DBIx::Threaded provides the following classes:

=over 4

=item DBIx::Threaded

main client side subclass of DBI

=item DBIx::Threaded::dr

client side subclass of DBI::dr

NOTE: since each connection is isolated in its own thread
(and hence, perl interpretter) context, use of the driver handle
is of marginal value, as any operations applied to a driver handle
derived from a DBIx::Threaded connection can only effect the driver running
in the container thread, and will have no effect on any of the other
connection instances.

=item DBIx::Threaded::db

client side subclass of DBI::db

=item DBIx::Threaded::st

client side subclass of DBI::st

=item DBIx::Threaded::Server

implements the server side, as a container class for DBI

=back

DBIx::Threaded provides all the same methods, attributes, and behaviors
as DBI, plus some additional methods relevant to asynchronous execution
and general threading housekeeping.


%prep
%setup -n %module_name-%module_version-RC1

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.txt TODO.txt
%perl_vendor_privlib/D*

%changelog
