%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Application.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.16
%define module_name DBIx-Tree-NestedSet
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: >connect('DBI:mysql:test','user','pass') or die ($DBI::errstr);
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DJ/DJCP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module implements a "Nested Set" parent/child tree, and is focused (at least in my mind) towards offering methods that make developing web applications easier. It should be generally useful, though.

See the "SEE ALSO" section for resources that explain the advantages and features of a nested set tree.  This module gives you arbitrary levels of nodes,  the ability to put in metadata associated with a node via simple method arguments and storage via DBI.  

There are currently drivers implemented for MySQL and SQLite version 2. For some reason this module segfaults on my debian boxes running SQLite 3. Use SQLite 2, unless you can figure out what's going on.

It should be trivial to write one for your RDBMS, see DBIx::Tree::NestedSet::MySQL for an example driver.

A nested set tree is "expensive" on updates because you have to edit quite a bit of the tree on inserts, deletes, or the movement of nodes.  Conversely, it is "cheaper" on just queries of the tree because nearly every action (getting children, getting parents, getting siblings, etc) can be done with one SQL statement.

If you're developing apps that require many reads and few updates to a tree (like pretty much every web app I've ever built) a nested set should offer significant performance advantages over the recursive queries required by the typical adjacency list model.

Whew. Say that fast three times.

Use the create_default_table() method to create your Nested Set table in your RDBMS.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
