# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name DBX-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Yet another DBI simplification wrapper.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MICHAEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is my DBI wrapper. There are many like it, but this one is mine.

I have a horrible memory for syntactic detail. This is one reason I've been developing a semantically oriented programming
language for the past decade, but in the meantime, when I write Perl to manage my accounting or suck data from the Web,
I use SQLite through DBI and I just can't ever remember the syntax. I don't know why. I'm usually fine on SQL syntax, at
least for the basic things I do most of the time, but the actual DBI methods escape me again and again.

This module is the syntax in my head, just so I don't have to keep looking everything up every single time. The class
subclasses DBI anyway, so anything you would do in DBI, you can do here - but with some simplifying alternative methods
as well.

   use DBX::Simple;
   
   my $dbh->DBX::Simple->connect(--DBI syntax--);  # Just so I can support everything DBI supports, after looking it up.
   my $dbh->DBX::Simple->open('sqlite file');      # 99%% of my work. ->mysql and ->postgresql would also be reasonable.
   
   my $value = $dbh->get ('select value from table where id=?', $id);  # Single value retrieval in one whack.
   my @rows = $dbh->select ('select * from table'); # Rowset retrieval. Yes, I know about selectrow_array. I just can't remember it.
   my $iter = $dbh->iterate ('select * from table'); # Returns an iterator that returns row arrayrefs.
   my $sth = $dbh->prepare (--DBI syntax--);
   
   $dbh->do ("insert ...");  # Regular insertion, just like in DBI, except the hashref is skipped because I can never remember it.
   my $record = $dbh->insert ("insert ..."); # Calls last_insert_id ('', '', '', ''), which will likely fail except with SQLite.
      
Simple. Like the name says. And exposes DBI anyway for when simple won't cut it, or when DBI is already simple.

One thing to notice: the class structure differs from DBI. DBX::Simple actually subclasses DBI::db - except for the `connect'
method. So any class-level calls should still be done through DBI, not DBX::Simple. (Easy for me to forget, as I never actually
do class-level stuff, except for those very rare times when I do.)
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
