%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/SASL.pm) perl(B.pm) perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Danga/Socket.pm) perl(Devel/Peek.pm) perl(Devel/Size.pm) perl(Digest/HMAC_SHA1.pm) perl(Digest/SHA1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(GTop.pm) perl(IO/Handle.pm) perl(IO/Socket/INET.pm) perl(IO/Socket/UNIX.pm) perl(List/Util.pm) perl(Log/Log4perl.pm) perl(MIME/Base64.pm) perl(Net/DNS.pm) perl(Net/LDAP.pm) perl(Net/SSLeay.pm) perl(Net/SSLeay/Handle.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Storable.pm) perl(Test/More.pm) perl(Text/Diff.pm) perl(Time/HiRes.pm) perl(Unicode/Stringprep.pm) perl(Unicode/Stringprep/Mapping.pm) perl(Unicode/Stringprep/Prohibited.pm) perl(XML/LibXML.pm) perl(XML/LibXML/SAX.pm) perl(XML/SAX.pm) perl(XML/SAX/Base.pm) perl(XML/SAX/ParserFactory.pm) perl(XML/SAX/PurePerl.pm) perl(base.pm) perl(blib.pm) perl(fields.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.85
%define module_name DJabberd
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(Filter/Util/Call.pm)

Name: perl-%module_name
Version: 0.85
Release: alt1
Summary: scalable, extensible Jabber/XMPP server.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MART/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
DJabberd was the answer to LiveJournal's Jabber (XMPP)
server needs.  We needed:

=over 4

=item * good performance for tons of connected users

=item * ability to scale to multiple nodes

=item * ability to hook into LiveJournal at all places, not just auth

=back

Basically we wanted the swiss army knife of Jabber servers (think
qpsmtpd or mod_perl), but none existed in any language.  While some
popular Jabber servers let us do pluggable auth, none let us get our
hands into roster storage, vcards, avatars, presence, etc.

So we made DJabberd.  It's a Jabber server where almost everything
defers to hooks to be implemented by plugins.  It does the core spec
itself (including SSL, StartTLS, server-to-server, etc), but it
doesn't come with any way to do authentication or storage or rosters,
etc.  You'll need to go pick up a plugin to do those.

You should be able to plop DJabberd into your existing systems /
userbase with minimal pain.  Just find a plugin that's close (if a
perfect match doesn't already exist!) and tweak.

DJabberd is event-based so we can have really low per-connection
memory requirements, smaller than is possible with a threaded jabber
server.  Because of this, all plugins can operate asynchronously,
taking as long as they want to finish their work, or to decline to the
next handler.  (in the meantime, while plugins wait on a response from
whatever they're talking to, the DJabberd event loop continues at full
speed) However, that's more work, so some plugins may choose to
operate synchronously, but they do so with the understanding that
those plugins will cause the whole server to get bogged down.  If
you're running a Jabber server for 5 users, you may not care that the
SQLite authentication backend pauses your server for milliseconds at a
time, but on a site with hundreds of thousands of connections, that
wouldn't be acceptable.  Watch out for those plugins.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README CHANGES doc examples
%perl_vendor_privlib/D*

%files scripts
%_bindir/*

%changelog
