# BEGIN SourceDeps(oneline):
BuildRequires: perl(DJabberd.pm) perl(Net/LDAP.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name DJabberd-Authen-LDAP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: An LDAP authentication module for DJabberd
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UR/URKLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
<VHost mydomain.com>

        [...]

        <Plugin DJabberd::Authen::LDAP>
            LDAPURI__ldap://localhost/
            LDAPBindDN__cn=reader
            LDAPBindPW__pass
            LDAPBaseDN__ou=people
            LDAPFilter__(&(inetAuthorizedServices=jabber)(uid=%%u))
            LDAPVersion         2
            LDAPMethod__rebind
        </Plugin>
    </VHost>

LDAPURI , LDAPBaseDN, and LDAPFilter are required
Everything else is optional.

The Only LDAPMethod supported at the moment is rebind which performs a bind as LDAPBindDN
 or does anonymous bind, then searches for the user using LDAPFilter and then will rebind
 as the found DN to verify the password.

LDAPFilter is an LDAP filter substutions
  - %%u will be substituted with the incoming userid (w/o the domain) (ie. myuser)
  - %%d will be substituted with the incoming userid's domain (ie. mydoman.com)

LDAPVersion is either 2 or 3, if nothing is specified then default to Net::LDAP default.
This value is passed straight to Net::LDAP

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
