%define module_version 0.44
%define module_name DR-Tarantool
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/Socket.pm) perl(Carp.pm) perl(Coro.pm) perl(Coro/AnyEvent.pm) perl(Cwd.pm) perl(Devel/GlobalDestruction.pm) perl(Digest/MD5.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(IO/Socket/INET.pm) perl(IO/Socket/UNIX.pm) perl(JSON/XS.pm) perl(List/MoreUtils.pm) perl(MIME/Base64.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(UUID.pm) perl(XSLoader.pm) perl(base.pm) perl(open.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.44
Release: alt7
Summary: a Perl driver for L<Tarantool|http://tarantool.org>
Group: Development/Perl
License: artistic
URL: https://github.com/dr-co/dr-tarantool

Source0: http://cpan.org.ua/authors/id/U/UN/UNERA/%{module_name}-%{module_version}.tar.gz

%description
This module provides a synchronous and asynchronous driver for
Tarantool.

The driver does not have external dependencies, but includes the
official light-weight Tarantool C client (a single C header which
implements all protocol formatting) for packing requests and unpacking
server responses.

This driver implements "iproto" protocol described in
https://github.com/mailru/tarantool/blob/master/doc/box-protocol.txt

It is built on top of the AnyEvent manpage - an asynchronous event
framework, and is therefore easiest to integrate into a program
which is already based on the AnyEvent manpage. A synchronous version of
the driver exists as well, it starts the AnyEvent manpage event machine for
every request. 

The driver supports three work flow types:

=over

=item the DR::Tarantool::AsyncClient manpage

The primary type, provides an asynchronous, callback-based 
API. Requires a running the AnyEvent manpage machine.

=item the DR::Tarantool::SyncClient manpage

Is built on top of the DR::Tarantool::AsyncClient manpage. Starts 
the AnyEvent manpage machine for every request. After a request is
served, the event loop is stopped, and the results
are returned to the caller, or, in case of an error, an
exception is thrown.

=item the DR::Tarantool::CoroClient manpage

Is also built on top of the DR::Tarantool::AsyncClient manpage, but is
designed to work in cooperative multitasking environment provided
by the Coro manpage. Is fully syntax-compatible with
the DR::Tarantool::SyncClient manpage, but requires a running event loop to
operate, like the DR::Tarantool::AsyncClient manpage. Requests from
different coroutines are served concurrently.

=back

Tarantool binary protocol
contains no representation of database schema or tuple field types.
Due to this deficiency, to easily integrate with Perl and automatically
convert tuple fields to Perl values, the driver needs to know field names
and types. To tell the driver about them, an instance of a dedicated class
must be used.
the DR::Tarantool::Spaces manpage is essentially a Perl hash which
describes field types and names for each space used in the program.
It can hardly be useful on its own, but once a connection is
"enlightened" with an instance of this class, access to all tuple
fields by a field name becomes possible. Type conversion, as
well as packing/unpacking from Tarantool binary format is
performed automatically.

Please follow the docs for the DR::Tarantool::Spaces manpage to learn
how to describe a schema.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
