# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Daemon-Shutdown
%define upstream_version 0.13

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_7

Summary:    Shutdown Daemon
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Daemon/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(AnyEvent.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IPC/Run.pm)
BuildRequires: perl(Log/Log4perl.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(User.pm)
BuildRequires: perl(YAML/Any.pm)
BuildArch:  noarch
Source44: import.info

%description
Tests the spin state of all the disks listed in "disks" every "loop_sleep".
When all disks are in spun down state, the flag "trigger_pending" is set.
If a further "trigger_time" seconds pass and all disks are still in a spun
down state, the trigger is sent back to the parent process (return 1).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.yml  README examples
%{perl_vendor_privlib}/*
%{_bindir}/sdd
%{_mandir}/man1/sdd.1*


%changelog
