# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer.pm) perl(Dancer/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(Regexp/Assemble.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.6
%define module_name Dancer-Plugin-DetectRobots
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6
Release: alt1
Summary: Dancer plugin to determine if the user is a robot
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DB/DBUSAROW/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A plugin for Dancer applications providing a keyword, is_robot,
which tests request->user_agent and returns 1 if the user_agent
appears to be a robot.

To use, simply call is_robot whenever/wherever you would like to 
know if the user is a bot or a human.  For example, if you would 
like to skip logging for bots

_if( ! is_robot ) {
__log_message("your log message");
_}

The plugin has been written to be as efficient as possible.  The
list of Robot UserAgent strings is only matched against request->user_agent
once per session.

This is done by storing its results in a session variable so a session
engine must be enabled.  Session::Cookie would be a poor choice since
the optimization will be lost when dealing with a search engine or robot.

The first call to is_robot in a session checks to see if the session 
variable has been set, if if it has, it returns 0 or 1 based upon the 
session variable.

By default the session variable key is "robot_client"

The check is done against the list of UserAgent strings used
by AWStats.  There are three levels of testing, BASIC which matches
AWStats LevelForRobotsDetection=1, EXTENDED which matches 
LevelForRobotsDetection=2 and GENERIC which is a very lax test.

By default the level is set to BASIC

You can change these settings. See the CONFIGURATION manpage
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes TODO
%perl_vendor_privlib/D*

%changelog
