%define module_name Dancer2-Plugin-Auth-ActiveDirectory
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Auth/ActiveDirectory.pm) perl(Carp.pm) perl(Dancer2.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Net/LDAP.pm) perl(Plack/Test.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Test/CheckManifest.pm) perl(Test/Net/LDAP.pm) perl(Test/Net/LDAP/Mock.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Requires.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt2
Summary: Dancer2 plugin for MS ActiveDirectory
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MZ/MZIESCHA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Configuration:

    plugins:
      Auth::ActiveDirectory:
        host: 0.0.0.0
        principal: yourprincpal
        domain: somedomain
        rights:
          definedright1: ad-group
          definedright2: ad-group
          definedright3: another-ad-group
          definedright4: another-ad-group

Code:

    post '/login' => sub {
        session 'user' => authenticate( params->{user}, params->{pass} );
        return template 'index', { html_error => 'Authentication failed!!' }
            unless ( session('user') );
        return template 'index', { html_error => 'No right for this page!!' }
            if( !has_right( session('user'), 'definedright1') );
        template 'index', { loggedin => 1 };
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/D*

%changelog
