%define module_name Dancer2-Plugin-Auth-Extensible
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/Simple/PAM.pm) perl(Carp.pm) perl(Crypt/SaltedHash.pm) perl(Dancer2.pm) perl(Dancer2/Core/Types.pm) perl(Dancer2/FileUtils.pm) perl(Dancer2/Plugin.pm) perl(Dancer2/Template/Tiny.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Share.pm) perl(File/ShareDir/Install.pm) perl(HTTP/BrowserDetect.pm) perl(HTTP/Cookies.pm) perl(HTTP/Request/Common.pm) perl(List/Util.pm) perl(Mail/Message.pm) perl(Mail/Message/Body/String.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Path/Tiny.pm) perl(Plack.pm) perl(Plack/Test.pm) perl(Scalar/Util.pm) perl(Session/Token.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/Fatal.pm) perl(Test/MockDateTime.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Try/Tiny.pm) perl(URI/Escape.pm) perl(Unix/Passwd/File.pm) perl(YAML.pm)
BuildRequires: perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.710
Release: alt1
Summary: extensible authentication framework for Dancer2 apps
Group: Development/Perl
License: perl
URL: https://github.com/PerlDancer/Dancer2-Plugin-Auth-Extensible/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABEVERLEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A user authentication and authorisation framework plugin for Dancer2 apps.

Makes it easy to require a user to be logged in to access certain routes,
provides role-based access control, and supports various authentication
methods/sources (config file, database, Unix system users, etc).

Designed to support multiple authentication realms and to be as extensible as
possible, and to make secure password handling easy (the base class for auth
providers makes handling `RFC2307'-style hashed passwords really simple, so you
have no excuse for storing plain-text passwords).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%if "%version" == "0.710"
%define _without_test 1
%endif


%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes example
%perl_vendor_privlib/D*
%perl_vendor_privlib/auto/share/dist/*

%files scripts
%_bindir/*

%changelog
