# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(HTTP/Request/Common.pm) perl(Plack/Test.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Dancer2-Plugin-ControllerAutoload
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Autoload controllers
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GI/GILS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
If you have these three controllers

    # MyApp/Controller/Users.pm
    package MyApp::Controller::Users;
    use Dancer2 appname => 'MyApp';

    # MyApp/Controller/Users/Thoughts.pm
    package MyApp::Controller::Users::Thoughts;
    use Dancer2 appname => 'MyApp';

    # MyApp/Controller/Services.pm
    package MyApp::Controller::Services;
    use Dancer2 appname => 'MyApp';

you'd have to load each with an `use'

    # MyApp.pm
    package MyApp;
    use Dancer2;
    use MyApp::Controller::Users;
    use MyApp::Controller::Users::Thoughts;
    use MyApp::Controller::Services;

This plugin simplifies this process. When you `use' the plugin, all
controllers will be loaded.

    # MyApp.pm
    package MyApp;
    use Dancer2;
    use Dancer2::Plugin::ControllerAutoload;

A controller will be by default identified as such if it is under the
`Controller' directory. But that's configurable. If your controller
directory is called "Contr":

    # in a config or environment file
    plugins:
        ControllerAutoload:
            controller_dir: Contr

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
