%define module_name Dancer2-Plugin-DebugDump
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(Dancer2/Plugin.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.41
Release: alt1
Summary: Modified debug behavior to create multi-line output that's easier for mere mortals to parse.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STEVIED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
By default, Dancer2's `debug' keyword outputs data structures to a single line. This plugin runs variables through `Data::Dumper' to produce output that is easier to read.

    use Dancer2;
    use Dancer2::Plugin::DebugDump;

    my $data_stucture = [ { 'key1' => 'value', 'key2' => 'value' }, { 'key1' => 'value' , 'key2' => 'value' } ];
    ddump($data_structure);

    # Sample output to your log or console
    DEBUG DUMP:
    $VAR1 = [
              {
                'key1' => 'value',
                'key2' => 'value'
              },
              {
                'key1' => 'value',
                'key2' => 'value',
              },
            ];

    # Accepts multiple arguments, each argument should be a scalar or a reference
    ddump($data_structure, $scalar_var, \@array_var, \%%hash_var, ... );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/D*

%changelog
