%define module_name Dancer2-Plugin-GraphQL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(Dancer2/Core/Types.pm) perl(Dancer2/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Function/Parameters.pm) perl(GraphQL.pm) perl(HTTP/Request/Common.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Runtime.pm) perl(Plack/Test.pm) perl(Test/More.pm) perl(blib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: a plugin for adding GraphQL route handlers
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `graphql' keyword which is exported by this plugin allow you to
define a route handler implementing a GraphQL endpoint.

Parameters, after the route pattern:

=over 4

=item $schema

A the GraphQL::Schema manpage object.

=item $root_value

An optional root value, passed to top-level resolvers.

=item $field_resolver

An optional field resolver, replacing the GraphQL default.

=item $route_handler

An optional route-handler, replacing the plugin's default - see example
above for possibilities.

It must return JSON-able Perl data in the GraphQL format, which is a hash
with at least one of a `data' key and/or an `errors' key.

If it throws an exception, that will be turned into a GraphQL-formatted
error.

=back

If you supply two code-refs, they will be the `$resolver' and
`$handler'. If you only supply one, it will be `$handler'. To be
certain, pass all four post-pattern arguments.

The route handler code will be compiled to behave like the following:

=over 4

=item *

Passes to the the GraphQL manpage execute, possibly via your supplied handler,
the given schema, `$root_value' and `$field_resolver'.

=item *

The action built matches POST / GET requests.

=item *

Returns GraphQL results in JSON form.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/D*

%changelog
