# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers/ActionPack.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Dancer2-Plugin-HTTP-ContentNegotiation
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Server-driven negotiation
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VA/VANHOESEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
HTTP specifies two types of content negotiation. These are server-driven
negotiation and agent-driven negotiation. Server-driven negotiation uses request
headers to select a variant, and agent-driven negotiation uses a distinct URI
for each variant.

This plugin handles server-driven negotiation.

    use Dancer2;
    
    use Dancer2::Plugin::HTTP::ContentNegotiation;
    
    get '/greetings' => sub {
        http_choose_language (
            'en'    => sub { 'Hello World' },
            'en-GB' => sub { 'Hello London' },
            'en-US' => sub { 'Hello Washington' },
            'nl'    => sub { 'Hallo Amsterdam' },
            'de'    => sub { 'Hallo Berlin' },
            # default is first in the list
        );
    };
    
    get '/choose/:id' => sub {
        my $data = SomeResource->find(param('id'));
        http_choose_media_type (
            'application/json'  => sub { to_json $data },
            'application/xml '  => sub { to_xml $data },
            { default => undef }, # default is 406: Not Acceptable
        );
    };
    
    get '/thumbnail/:id' => sub {
        http_choose_media_type (
            [ 'image/png', 'image/gif', 'image/jpeg' ]
                => sub { Thumbnail->new(param('id'))->to(http_chosen->minor) },
            { default => 'image/png' }, # must be one listed above
        );
    };
    
    dance;
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes examples
%perl_vendor_privlib/D*

%changelog
