# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Load.pm) perl(Crypt/PRNG.pm) perl(Dancer2.pm) perl(Dancer2/Plugin.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Plack/Test.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(URI.pm) perl(URI/QueryParam.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name Dancer2-Plugin-OAuth2-Server
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Easier implementation of an OAuth2 Authorization Server / Resource Server with Dancer2 Port of Mojo...
Group: Development/Perl
License: perl
URL: https://github.com/pierre-vigier/dancer2-plugin-oauth2-server

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PV/PVIGIER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Dancer2::Plugin::OAuth2::Server is a port of Mojolicious plugin for OAuth2 server
With this plugin, you can implement an OAuth2 Authorization server and Resource server without too much hassle.
The Basic flows are implemented, authorization code, access token, refresh token, ...

A "simple" implementation is provided with a "in memory" session management, however, it will not work on multi process persistent
environment, as each restart will loose all the access/refrest tokens. Token will also not be shared between processes.

For a usable implementation in a realistic context, you will need to create a class implementing the Role Dancer2::Plugin::OAuth2::Server::Role,
and configure the server_class option in configuration of the plugin. The following methods needs to be implemented:

_login_resource_owner
_confirm_by_resource_owner
_verify_client
_store_auth_code
_generate_token
_verify_auth_code
_store_access_token
_verify_access_token

On the resource server side, to protect a resource, just use the dsl keyword oauth_scopes with
either one scope or the list of scope needed. In case the authorization header provided is not correct,
a 400 http code is returned with an erro message.
If the Authorization header is correct and the access is granted, the access token information are
stored within the var keyword, in oauth_access_token, for the time of the request. You can access the
access token information through var('oauth_access_token') within the route code itself.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/D*

%changelog
