%define module_name Dancer2-Plugin-SPID
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/JWT.pm) perl(Dancer2.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Net/SPID.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: SPID authentication for Dancer2 web applications
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Dancer2;
    use Dancer2::Plugin::SPID;
    
    hook 'plugin.SPID.after_login' => sub {
        # log assertion:
        info "User " . spid_session->nameid . " logged in";
        info "SPID Assertion: " . spid_session->assertion_xml;
    };
    
    hook 'plugin.SPID.after_logout' => sub {
        debug "User " . spid_session->nameid . " logged out";
    };

    dance;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES README.md README AUTHORS example
%perl_vendor_privlib/D*

%changelog
