# BEGIN SourceDeps(oneline):
BuildRequires: perl(Log/Any.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Ouch.pm) perl(Path/Tiny.pm) perl(Template/Perlish.pm) perl(Test/Pod.pm) perl(Try/Catch.pm) perl(experimental.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Data-Annotation
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Analyze data iptables-like
Group: Development/Perl
License: apache
URL: https://codeberg.org/polettix/Data-Annotation/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Generic framework for defining iptables-like chains of rules, apply them
on data and get back an overall *annotation* about it. This annotation
can be whatever, e.g. strings `accept' and `reject' (following the
spirit of iptables) or more complicated stuff like data structures
describing whatever has been analyzed.

The definition is a hash with the following high-level structure:

   my %%da_def = (
      chains:     => \%%hash_of_chains,
      default     => 'some annotation',
      description => 'string...',
      'condition-parse-context' => \%%hash_of_configurations,
   );

This high level is much like a table in iptables, containing a number of
*chains* below. `default' represents the default annotation if none of
the chains provides any result back, much like the `POLICY' in a table
in iptables. The `parse_context' provides some more kick for generating
a function but it's totally optional, much like the `description'.

A *chain* has the following structure:

   my %%chain = (
      rules       => \@rules,
      description => 'string...',
      'condition-parse-context' => \%%hash_of_configurations,
   );

A chain is a sequence of *rules*, which will be analyzed in order, much
like what happens in iptables.

A *rule* has the following structure:

   my %%rule = (
      condition => <expression/expression-definition/plain-scalar>,
      return    => <call/goto/whatever else>
      description => 'string...',
      'condition-parse-context' => \%%hash_of_configurations,
   );

When a rule is evaluated, the *condition* is checked first. It can be a
plain scalar, in which case it's considered a boolean value, or a hash
definition, which will be inflated via the Data::Annotation::Expression manpage,
or a sub reference that accepts a *runtime context* that most of the
time will be a hash reference of sort.

If the *condition* gives a true value, the `return' value is provided
back as the result of the rule *and*. This result can be *almost*
anything:

=over

=item *

if it's a hash reference, it should only c...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
