%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/AutoClass.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(TAP/Formatter/Console.pm) perl(TAP/Harness.pm) perl(TAP/Parser/Aggregator.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Data-Babel-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: A Client to access the Babel web service.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PH/PHONYBONE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
BabelClient.pm provides access to the babel web service.  The Babel web service provides
translations between biological identifiers of various types.  For example, given a list 
of Entrez gene ids, it can provide the corresponding Ensembl gene ids, UniProt
protien ids, and so forth.  The full list of available identifiers, and accompanying
English descriptions, can be obtained by making a call to the 'idtypes' method.

This web service client provides two calls, idtypes() and translate().  Both of these calls mimic 
calls of the same names found in Data::Babel, which also provides full documentation.  It is intended 
that the API's of the corresponding calls be exactly the same.

The main method is 'translate'.  It makes a request to the web service to translate identifiers.
The parameters to translate are:
- input_type: a string describing the type of the input identifiers.  This type must match
              exactly with one of the values returned by the 'idtypes' method.
- input_ids: a listref containing the actual identifiers to be translated.
- output_types: a listref containing the output types desired, ie, the translations from
                'input_type'.  For example, if you have a list of Uniprot ids and you
                would like to know what are the corresponding Ensembl gene ids, gene symbols,
                and associated OMIM numbers, you would pass the list [qw(gene_ensembl gene_symbol function_omim)]

As mentioned, the method 'idtypes' provides a list of all valid id types for use in the 'translate' method 
(for both 'input_type' and 'output_type').  The 'idtypes' method takes no parameters.

NOTE: not all translations are 1-to-1.  Many of the translations will return more than one output value
for a given input value.  For example, there are multiple Affymetrix probeset ids for many genes.
In this case, there will be one row for each unique combination of return values, so if there were
six Affymetrix probe ids for a given Entrez gene id, there would be six rows in the returned array
for that Entrez gene id, with the value for the Entrez gene id repeated in each row.  Were you to 
request two non-unique translations to a call to 'translate', the returned array would contain all
the different combinations of values, one on each row.  In this way the returned array can grow in 
size so as to overwhelm the capabilities of the server, the web, and so forth, and caution must be used
in making requests to the server.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
