%define module_version 0.03
%define module_name Data-CircularList
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: simple implementation for using CircularList data structure.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHINCHIT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Quick summary of what the module does.

Perhaps a little code snippet.

    use Data::CircularList;

    my $list = Data::CircularList->new;
    $list->insert(20);
    $list->insert(15);
    $list->insert(18);
    $list->insert(37);
    $list->insert(3);

    # display
    my $iter = $list->iterator;
    while ($iter->has_next) {
       print $iter->next->data . "\n";
    }
    # you can see result sorted
    # 3
    # 15
    # 18
    # 20
    # 37
    #  3  <= 1st value is displayed
    # 15     eternal loop
    ...
    
    # rotate display
    my $iter = $list->iterator( rotate => 2 );
    while ($iter->has_next) {
       print $iter->next->data . "\n";
    }
    # you can see result sorted
    # 3
    # 15
    # 18
    # 20
    # 37
    #  3
    # 15
    # 18
    # 20
    # 37 <= end. $iter->has_next return true until second rotation completed.
    
    # you can also use strings as cells
    $list = Data::CircularList->new;
    $list->insert('steeve');
    $list->insert('hisashi');
    $list->insert('takairo');
    $list->insert('kazuyo');
    $list->insert('jane');
    
    # display
    $iter = $list->iterator;
    while ($iter->has_next) {
       print $iter->next->data . "\n";
    }
    # you can see result sorted
    # hisashi
    # jane
    # kazuyo
    # takahiro
    # steeve
    # hisashi  <= 1st value is displayed
    # jane        eternal loop
    ...

    # display
    $iter = $list->iterator( rotate => 2 );
    while ($iter->has_next) {
       print $iter->next->data . "\n";
    }
    # you can see result sorted
    # hisashi
    # jane
    # kazuyo
    # takahiro
    # steeve
    # hisashi
    # jane
    # kazuyo
    # takahiro
    # steeve <= end. $iter->has_next return true until second rotation completed.

    # you can also use some object as cells
    $list = Data::CircularList->new;
    $list->insert(Person->new(name => 'lally'));
    $list->insert(Person->new(name => 'hisashi'));
    $list->insert(Person->new(name => 'takairo'));
    $list->insert(Person->new(name => 'kazuyo'));
    $list->insert(Person->new(name => 'jane'));
    
    # you have to implements compare_to method in you object.
    # you have to write sort logic in compare_to method.
    package Person;

    sub new {
        my $class = shift;
        my %%args = @_;
        my $self = {
            name => $args{'name'},
            length => length($args{'name'}),
        };
        bless $self => $class;
        $self->length(length($args{'name'}));
        return $self;
    }

    # sort by length of name, and name
    sub compare_to {
        my $self = shift;
        my $cell = shift;

        if ($self->length > $cell->length) {
            return 1;
        } elsif ($self->length == $cell->length) {
            return $self->name gt $cell->name ? 1 : 0;
        } else {
            return 0;
        }
    }

    sub name {
        my $self = shift;
        return defined $self->{'name'} ? $self->{'name'} : undef;
    }

    sub length {
        my $self = shift;
        return defined $self->{'length'} ? $self->{'length'} : undef;
    }
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
