# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Data-Decrement
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Provide extra magic logic for auto-decrement
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Decrement

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perl's auto-increment operator (`++') has some convenience feature built in.
Quoting the perlop manpage:

 The auto-increment operator has a little extra builtin magic to it. If you
 increment a variable that is numeric, or that has ever been used in a numeric
 context, you get a normal increment. If, however, the variable has been used in
 only string contexts since it was set, and has a value that is not the empty
 string and matches the pattern "/^[a-zA-Z]*[0-9]*\z/", the increment is done as
 a string, preserving each character within its range, with carry:

  print ++($foo = "99");      # prints "100"
  print ++($foo = "a0");      # prints "a1"
  print ++($foo = "Az");      # prints "Ba"
  print ++($foo = "zz");      # prints "aaa"

 "undef" is always treated as numeric, and in particular is changed to 0 before
 incrementing (so that a post-increment of an undef value will return 0 rather
 than "undef").

 The auto-decrement operator is not magical.

This module provides the `decr()' function to do the decrement equivalent,
although it is not exactly the reverse of the increment operation. In general,
the rule is that `decr(++$a)' should return the same value as the original
`$a' before the auto-increment, with a couple of exception.

=over

=item * Positive integers are decremented as string

Positive integers, including those with zero prefix, are decremented as string.

 print decr(-123);            # prints "-124", treated as number
 print decr(123);             # prints "122", treated as string
 print decr(100);             # prints "099", treated as string

"undef" like in auto-increment is treated as number 0.

 print decr(undef);            # prints "-1", treated as number

=item * Decrementing is not done when leftmost digit is already "A", "a", or 0

When carrying over to the left-most digit, and the digit is already "A", "a", or
"0", decrementing is not done. The original value is returned and a warning
"Cannot decrement '<VALUE>'" is issued. Examples:

 print decr(0);               # prin...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/D*

%changelog
