# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-Module-Build perl-podlators
# END SourceDeps(oneline)
%define upstream_name    Data-Domain
%define upstream_version 1.06

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_6

Summary:    Data description and validation
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/Data/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Date/Calc.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Scalar/Does.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(autouse.pm)
BuildRequires: perl(experimental.pm)
BuildArch:  noarch
Source44: import.info

%description
A data domain is a description of a set of values, either scalar or
structured (arrays or hashes). The description can include many
constraints, like minimal or maximal values, regular expressions, required
fields, forbidden fields, and also contextual dependencies. From that
description, one can then invoke the domain's 'inspect' method to check if
a given value belongs to it or not. In case of mismatch, a structured set
of error messages is returned.

The motivation for writing this package was to be able to express in a
compact way some possibly complex constraints about structured data.
Typically the data is a Perl tree (nested hashrefs or arrayrefs) that may
come from XML, JSON, from a database through DBIx::DataModel, or from
postprocessing an HTML form through CGI::Expand. 'Data::Domain' is a kind
of tree parser on that structure, with some facilities for dealing with
dependencies within the structure, and with several options to finely tune
the error messages returned to the user.

There are several other packages in CPAN doing data validation; these are
briefly listed in the the /"SEE ALSO" manpage section.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
%{__perl} Build.PL --install_path bindoc=%_man1dir --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*


%changelog
