# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 1.12
%define module_name Data-Dumper-Sorted
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.12
Release: alt1
Summary: Dumper with repeatable signature
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
- similar to Data::Dumper

Data::Dumper::Sorted generates a unique signature for hashs
by sorting the keys into alphabetic order.

Data::Dumper actually does much more than this, however, it
does not stringify hash's in a consistent manner. i.e. no SORT

The routines below, while not covering recursion loops, non ascii
characters, etc.... does produce text that can be eval'd and is 
consistent with each rendering, version of Perl, and platform.

The module routines may be called as functions or methods.

  use Data::Dumper::Sorted qw(
_hexDumper
_hexDumperC
_hexDumperA
_Dumper
_DumperC
_DumperA
  };

OR as methods

  require Data::Dumper::Sorted;

  my $dd = new Data::Dumper::Sorted;

A blessed reference is not really needed.

  my $dd = 'Data::Dumper::Sorted';

  $countText = $dd->hexDumperC($ref);
  $evalText  = $dd->hexDumper($ref);
  ($text,$count) = $dd->hexDumperA($ref);

  $countText = $dd->DumperC($ref);
  $evalText  = $dd->Dumper($ref);
  ($text,$count) = $dd->DumperA($ref);

=item * $dd = new Data::Dumper::Sorted;

This method returns a blessed reference that can be used to access the
functions in this modules as methods.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
