%define module_name Data-Edit-Xml
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dump.pm) perl(Data/Table/Text.pm) perl(GitHub/Crud.pm) perl(Module/Build.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test2/API.pm) perl(XML/Parser.pm) perl(utf8.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20201031
Release: alt1
Summary: Edit data in xml format
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PR/PRBRENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Data::Edit::Xml;

 say STDERR Data::Edit::Xml::new(inputString=><<END)->                          # Docbook to Dita example
<sli>
  <li>
    <p>Diagnose the problem</p>
    <p>This can be quite difficult</p>
    <p>Sometimes impossible</p>
  </li>
  <li>
  <p><pre>ls -la</pre></p>
  <p><pre>
drwxr-xr-x  2 phil phil   4096 Jun 15  2016 Desktop
drwxr-xr-x  2 phil phil   4096 Nov  9 20:26 Downloads
</pre></p>
  </li>
</sli>
END

 by(sub
  {my ($o, $p) = @_;
   if ($o->at(qw(pre p li sli)) and $o->isOnlyChild)
    {$o->change($p->isFirst ? qw(cmd) : qw(stepresult));
     $p->unwrap;
    }
   elsif ($o->at(qw(li sli)) and $o->over(qr(\Ap( p)+\Z)))
    {$_->change($_->isFirst ? qw(cmd) : qw(info)) for $o->contents;
    }
  })->by(sub
  {my ($o) = @_;
   if    ($o->at(qw(li sli))) {$o->change(qw(step))}
   elsif ($o->at(qw(sli)))    {$o->change(qw(steps))}
   $o->id = 's'.($o->position+1) if $o->at(qw(step));
   $o->id = 'i'.($o->index+1)    if $o->at(qw(info));
   $o->wrapWith(qw(screen))      if $o->at(qw(CDATA stepresult));
  })->string =~ s/></>\n</gr;

 Prints (after being formatted for easier reading):

 # <steps>
 #   <step id="s1">
 #     <cmd>Diagnose the problem</cmd>
 #     <info id="i1">This can be quite difficult</info>
 #     <info id="i2">Sometimes impossible</info>
 #     </step>
 #   <step id="s2">
 #     <cmd>ls -la</cmd>
 #     <stepresult>
 #       <screen>
 # drwxr-xr-x  2 phil phil   4096 Jun 15  2016 Desktop
 # drwxr-xr-x  2 phil phil   4096 Nov  9 20:26 Downloads
 #       </screen>
 #     </stepresult>
 #   </step>
 # </steps>
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md CHANGES CONTRIBUTING README
%perl_vendor_privlib/D*

%changelog
